'PROJLIB 
'	THIS MODULE CONTAINS ALL OF THE VERSION 5 CODE TO SUPPORT
'	PROJECTIONS OF LATUTUDE-LONGITUDE TO XY ALSO CONTAINS CODE
'	TO SETUP THE VARIOUS PROJECTIONS FROM A PROJECTION PARAMETER FILE
'
DEFDBL A-Z
OPTION BASE 1
DECLARE FUNCTION DBLMAX(A,B)
FUNCTION ConvertToDoubleDegrees(FAC,D,M,S)
	ConvertToDoubleDegrees=FAC*(ABS(D)+ABS(M)/60#+ABS(S)/3600#)
END FUNCTION
DEF FNARCSIN(CON)
' FUNCTION TO COMPUTE ASIN FUNCTION
	ONE=1.0D0
	FNARCSIN=ATN(CON/SQR(ONE-CON*CON))
END DEF
DEF FNACOS(CON)
' FUNCTION TO COMPUTE ACOS FUNCTION
	ONE=1.0D0
	FNACOS=ATN(SQR(ONE-CON*CON)/CON)
END DEF
DEF FNADJL (LON)
' FUNCTION TO ADJUST LONGITUDE ANGLE TO MODULE 180 DEGREES.
	TWO=2.0D0
	PI=3.14159265358979323846D0
	TWOPI = TWO * PI
	FNADJL = LON
	WHILE ABS(LON) > PI
		LON = LON - SGN(LON)*TWOPI
		FNADJL=LON
	WEND
END DEF
DEF FNASIN (CON)
' THIS FUNCTION ADJUSTS FOR ROUND-OFF ERRORS IN COMPUTING ARCSINE
	ONE=1.0D0
	IF (ABS(CON)>ONE) THEN
		CON = SGN(CON)*ONE
	END IF
	FNASIN=FNARCSIN (CON)
END DEF
DEF FNE0 (ECCNTS)
' FUNCTION TO COMPUTE CONSTANT (E0).
	ONE=1.0D0
	QUART=0.25D0
	ONEQ=1.25D0
	THREE=3.0D0
	SIXT=16.0D0
	FNE0 = ONE - QUART * ECCNTS * (ONE + ECCNTS / SIXT * _
		(THREE + ONEQ * ECCNTS))
END DEF
DEF FNE1 (ECCNTS)
' FUNCTION TO COMPUTE CONSTANT (E1).
	CON1=0.375D0
	CON2=0.25D0
	CON3=0.46875D0
	ONE=1.0D0
	FNE1 = CON1 * ECCNTS * (ONE + CON2 * ECCNTS * _
		(ONE + CON3 * ECCNTS))
END DEF
DEF FNE2 (ECCNTS)
' FUNCTION TO COMPUTE CONSTANT (E2).
	CON1=0.05859375D0
	CON2=0.75D0
	ONE=1.0D0
	FNE2 = CON1 * ECCNTS * ECCNTS * (ONE + CON2 * ECCNTS)
END DEF
DEF FNE3 (ECCNTS)
' FUNCTION TO COMPUTE CONSTANT (E3).
	CON=0.113932291666667D-01
	FNE3 = CON * (ECCNTS^3)
END DEF
DEF FNE4 (ECCENT)
' FUNCTION TO COMPUTE CONSTANT (E4).
	ONE=1.0D0
	CON = ONE + ECCENT
	DCOM = ONE - ECCENT
	FNE4 = SQR((CON ^ CON) * (DCOM ^ DCOM))
END DEF
DEF FNPHI1 (ECCENT,QS,IFLG)
' FUNCTION TO COMPUTE LATITUDE ANGLE (PHI-1).
	HALF=0.5D0
	ONE=1.0D0
	EPSLN=1.0D-7
	TOL=1.0D-10
	NIT%=15
	PHI1 = FNASIN (HALF * QS)
	IF ECCENT >= EPSLN THEN
		ECCNTS = ECCENT * ECCENT
		PHI = PHI1
		FOR II% = 1 TO NIT%
			SINPI = SIN (PHI)
			COSPI = COS (PHI)
			CON = ECCENT * SINPI
			DCOM = ONE - CON * CON
			DPHI = HALF * DCOM * DCOM / COSPI * (QS / (ONE - ECCNTS) - _
				SINPI / DCOM + HALF / ECCENT * LOG ((ONE - CON) / _
				(ONE + CON)))
			PHI = PHI + DPHI
			IF (ABS(DPHI) <= TOL) GO TO PHI120
			PHI1 = PHI
		NEXT II%
		PRINT "LATITUDE FAILED TO CONVERGE"
		IFLG = 21
	END IF
PHI120:      FNPHI1 = PHI1
END DEF
DEF FNPHI2 (ECCENT,TS,IFLG)
' FUNCTION TO COMPUTE LATITUDE ANGLE (PHI-2).
	HALFPI=1.57079632679489661923D0
	HALF=0.5D0
	ONE=1.0D0
	TWO=2.0D0
	TOL=1.0D-10
	NIT%=15
	ECCNTH = HALF * ECCENT
	PHI = HALFPI - TWO * ATN (TS)
	FOR II% = 1 TO NIT%
		SINPI = SIN (PHI)
		CON = ECCENT * SINPI
		DPHI = HALFPI - TWO * ATN (TS * ((ONE - CON) / _
			(ONE + CON)) ^ ECCNTH) - PHI
		PHI = PHI + DPHI
		IF ABS(DPHI) <= TOL GOTO PHI220
		FNPHI2 = PHI
	NEXT II%
	PRINT "LATITUDE FAILED TO CONVERGE"
	IFLG = 22
PHI220:      END DEF
DEF FNPHI3 (ML,E0,E1,E2,E3,IFLG)
' FUNCTION TO COMPUTE LATITUDE ANGLE (PHI-3).
	TWO=2.0D0
	FOUR=4.0D0
	SIX=6.0D0
	TOL=1.0D-11
	NIT%=15
	PHI = ML
	FOR II% = 1 TO NIT%
		DPHI = (ML + E1 * SIN (TWO * PHI) - E2 * SIN (FOUR * PHI) + _
			E3 * SIN (SIX * PHI)) / E0 - PHI
		PHI = PHI + DPHI
		IF (ABS(DPHI) <= TOL) GO TO PHI320
		FNPHI3 = PHI
	NEXT II%
	PRINT "LATITUDE FAILED TO CONVERGE
	IFLG = 23
PHI320:      END DEF
DEF FNML (E0,E1,E2,PHI)
' FUNCTION TO COMPUTE CONSTANT (M).
	TWO=2.0D0
	FOUR=4.0D0
	FNML = E0 * PHI - E1 * SIN (TWO * PHI) + _
		E2 * SIN (FOUR * PHI)
END DEF
DEF FNMS (ECCENT,SINPHI,COSPHI)
' FUNCTION TO COMPUTE CONSTANT (SMALL M).
	ONE=1.0D0
	CON = ECCENT * SINPHI
	FNMS = COSPHI / SQR (ONE - CON * CON)
END DEF
DEF FNQS (ECCENT,SINPHI,COSPHI)
' FUNCTION TO COMPUTE CONSTANT (SMALL Q).
	HALF=0.5D0
	ONE=1.0D0
	TWO=2.0D0
	EPSLN=1.0D-7
	IF (ECCENT >= EPSLN) THEN
		CON = ECCENT * SINPHI
		FNQS = (ONE - ECCENT * ECCENT) * (SINPHI / (ONE - CON * CON) - _
			(HALF / ECCENT) * LOG ((ONE - CON) / (ONE + CON)))
	ELSE
		FNQS = TWO * SINPHI
	END IF
END DEF
DEF FNTS (ECCENT,PHI,SINPHI)
' FUNCTION TO COMPUTE CONSTANT (SMALL T).
	HALF=0.5D0
	ONE=1.0D0
	HALFPI=1.57079632679489661923D0
	CON = ECCENT * SINPHI
	DCOM = HALF * ECCENT
	CON = ((ONE - CON) / (ONE + CON)) ^ DCOM
	FNTS = TAN (HALF * (HALFPI - PHI)) / CON
END DEF
SUB CORNER (UNIT%,IBAT$,DB1,DB2) STATIC
' $DYNAMIC
DIM LATFAC(2),LONFAC(2)
' $STATIC
	LATFAC(1)=1#:LATFAC(2)=-1#
	LONFAC(1)=1#:LONFAC(2)=-1#
LPDBC:	IF IBAT$="Y" THEN
		INPUT #UNIT%,LATD,LATM,LATS,LAT$,LOND,LONM,LONS,LON$
	ELSE
		INPUT  "DD,MM,SS,C,DDD,MM,SS,C: ",LATD,LATM,LATS,LAT$,LOND,LONM,LONS,LON$
	END IF
	LAT$=UCASE$(LAT$)
	LON$=UCASE$(LON$)
	IF LAT$="N" THEN
		ILAT%=1
	ELSEIF LAT$="S" THEN
		ILAT%=2
	ELSE
		PRINT "INVALID LATITUDE CODE (USE N OR S)"
		IF IBAT$="N" THEN
			GOTO LPDBC
		ELSE
			PRINT "USING DEFAULT OF N"
			ILAT%=1
		END IF
	END IF
	IF LON$="E" THEN
		ILON%=1
	ELSEIF LON$="W" THEN
		ILON%=2
	ELSE
		PRINT "INVALID LONGITUDE CODE (USE E OR W)"
		IF IBAT$="N" THEN
			GOTO LPDBC
		ELSE
			PRINT "USING DEFAULT OF W"
			ILON%=2
		END IF
	END IF
	DB1 = ConvertToDoubleDegrees(LATFAC(ILAT%),LATD,LATM,LATS)
	DB2 = ConvertToDoubleDegrees(LONFAC(ILON%),LOND,LONM,LONS)
	ERASE LATFAC,LONFAC
END SUB
SUB SetupProjection(PTYP%,DARRAY(1),CM,ECODE%) STATIC
' $DYNAMIC
DIM LATFAC(2),LONFAC(2)
' $STATIC
	LATFAC(1)=1#:LATFAC(2)=-1#
	LONFAC(1)=1#:LONFAC(2)=-1#
	FOR I%=1 TO 8
		DARRAY(I%)=0
	NEXT I%
	INPUT #5,PTYP%
	INPUT #5,DARRAY(1)
	INPUT #5,DARRAY(2)
	IF (PTYP%=1) OR (PTYP%=6) THEN
		INPUT #5,LOND,LONM,LONS,LON$
		LON$=UCASE$(LON$)
		IF LON$="E" THEN
			ILON%=1
		ELSE
			ILON%=2
		END IF
		DARRAY(3)=ConvertToDoubleDegrees(LONFAC(ILON%),LOND,LONM,LONS)
		CM=DARRAY(3)
		INPUT #5,DARRAY(4)
	ELSEIF (PTYP%=2) OR (PTYP%=3) OR (PTYP%=8) THEN
		INPUT #5,LATD,LATM,LATS,LAT$
		LAT$=UCASE$(LAT$)
		IF LAT$="N" THEN
			ILAT%=1
		ELSE
			ILAT%=2
		END IF
		DARRAY(3)=ConvertToDoubleDegrees(LATFAC(ILAT%),LATD,LATM,LATS)
		INPUT #5,LATD,LATM,LATS,LAT$
		LAT$=UCASE$(LAT$)
		IF LAT$="N" THEN
			ILAT%=1
		ELSE
			ILAT%=2
		END IF
		DARRAY(4)=ConvertToDoubleDegrees(LATFAC(ILAT%),LATD,LATM,LATS)
		INPUT #5,LOND,LONM,LONS,LON$
		LON$=UCASE$(LON$)
		IF LON$="E" THEN
			ILON%=1
		ELSE
			ILON%=2
		END IF
		DARRAY(5)=ConvertToDoubleDegrees(LONFAC(ILON%),LOND,LONM,LONS)
		CM=DARRAY(5)
	ELSEIF PTYP%=4 THEN
		INPUT #5,LOND,LONM,LONS,LON$
		LON$=UCASE$(LON$)
		IF LON$="E" THEN
			ILON%=1
		ELSE
			ILON%=2
		END IF
		DARRAY(3)=ConvertToDoubleDegrees(LONFAC(ILON%),LOND,LONM,LONS)
		CM=DARRAY(3)
	ELSEIF PTYP%=5 THEN
		INPUT #5,LOND,LONM,LONS,LON$
		LON$=UCASE$(LON$)
		IF LON$="E" THEN
			ILON%=1
		ELSE
			ILON%=2
		END IF
		DARRAY(3)=ConvertToDoubleDegrees(LONFAC(ILON%),LOND,LONM,LONS)
		CM=DARRAY(3)
	ELSEIF PTYP%=7 THEN
		INPUT #5,DARRAY(3)
		INPUT #5,LATD,LATM,LATS,LAT$
		LAT$=UCASE$(LAT$)
		IF LAT$="N" THEN
			ILAT%=1
		ELSE
			ILAT%=2
		END IF
		DARRAY(4)=ConvertToDoubleDegrees(LATFAC(ILAT%),LATD,LATM,LATS)
		INPUT #5,LOND,LONM,LONS,LON$
		LON$=UCASE$(LON$)
		IF LON$="E" THEN
			ILON%=1
		ELSE
			ILON%=2
		END IF
		DARRAY(5)=ConvertToDoubleDegrees(LONFAC(ILON%),LOND,LONM,LONS)
		INPUT #5,LATD,LATM,LATS,LAT$
		LAT$=UCASE$(LAT$)
		IF LAT$="N" THEN
			ILAT%=1
		ELSE
			ILAT%=2
		END IF
		DARRAY(6)=ConvertToDoubleDegrees(LATFAC(ILAT%),LATD,LATM,LATS)
		INPUT #5,LOND,LONM,LONS,LON$
		LON$=UCASE$(LON$)
		IF LON$="E" THEN
			ILON%=1
		ELSE
			ILON%=2
		END IF
		DARRAY(7)=ConvertToDoubleDegrees(LONFAC(ILON%),LOND,LONM,LONS)
		INPUT #5,LATD,LATM,LATS,LAT$
		LAT$=UCASE$(LAT$)
		IF LAT$="N" THEN
			ILAT%=1
		ELSE
			ILAT%=2
		END IF
		DARRAY(8)=ConvertToDoubleDegrees(LATFAC(ILAT%),LATD,LATM,LATS)
		INPUT #5,LOND,LONM,LONS,LON$
		LON$=UCASE$(LON$)
		IF LON$="E" THEN
			ILON%=1
		ELSE
			ILON%=2
		END IF
		DARRAY(9)=ConvertToDoubleDegrees(LONFAC(ILON%),LOND,LONM,LONS)
		CM=DARRAY(5)
	ELSE
		LOCATE 25,1: PRINT "INVALID PROJECTION - HIT ANY KEY TO CONTINUE";
		LOCATE 25,78: IDUM$=INPUT$(1)
                ECODE%=1
	END IF
	CLOSE #5
	ERASE LATFAC,LONFAC
END SUB
SUB PROJECT(GEOG(1),PROJ(1),ZONE%,PTYP%,JOB%,DARRAY(1)) STATIC
STATIC E,E0,E1,E2,E3,ES,ESP,A,B,C,IND,NS,AL,BL,EL,LON0,LAT0,RH0, _
		F,M1,ML0,MS,KS0,SINGAM,COSGAM,COSALF,SINALF
	ZERO=0.0D0
	HALFPI=1.57079632679489661923D0
	PI=3.14159265358979323846D0
	DGR=PI/180.0D0
	HALF=0.5D0
	ONE=1.0D0
	TWO=2.0D0
	THREE=3.0D0
	FOUR=4.0D0
	FIVE=5.0D0
	SIX=6.0D0
	SEVEN=7.0D0
	EIGHT=8.0D0
	NINE=9.0D0
	TEN=10.0D0
	TOL=1.0D-7
	EPSLN=1.0D-10
	NIT%=6
	IF (ZONE%=PTYP%) GOTO INITIALIZE
	ZONE%=PTYP%
	ON PTYP% GOTO IS01,IS02,IS03,IS04,IS05,IS06,IS07,IS08
	PRINT "ILLEGAL PROJECTION"
	GOTO RETSUB
IS01:
	IFLG = 0
	GOTO IS06
IS02:
	IFLG = 0
	A = DARRAY(1)
	B = DARRAY(2)
	IF A = B THEN
		E = ZERO
		ES = ZERO
	ELSE
		ES = ONE - (B / A) ^ 2
		E = SQR (ES)
	END IF
	LAT1=DGR*DARRAY(3)
	LAT2=DGR*DARRAY(4)
	IF (ABS(LAT1+LAT2) < EPSLN) THEN
		PRINT " EQUAL LATITUDES FOR ST. PARALLELS ON OPPOSITE "
		PRINT " SIDES OF EQUATOR"
		IFLG = 301
		GOTO RETSUB
	END IF
	LON0=DGR*DARRAY(5)
	LAT0=ZERO
	SINPHI = SIN (LAT1)
	CON = SINPHI
	COSPHI = COS (LAT1)
	MS1 = FNMS (E,SINPHI,COSPHI)
	QS1 = FNQS (E,SINPHI,COSPHI)
	SINPHI = SIN (LAT2)
	COSPHI = COS (LAT2)
	MS2 = FNMS (E,SINPHI,COSPHI)
	QS2 = FNQS (E,SINPHI,COSPHI)
	SINPHI = SIN (LAT0)
	COSPHI = COS (LAT0)
	QS0 = FNQS (E,SINPHI,COSPHI)
	IF ABS(LAT1-LAT2) < EPSLN THEN
		NS = CON
	ELSE
		NS = (MS1 * MS1 - MS2 * MS2) / (QS2 - QS1)
	END IF
	C = MS1 * MS1 + NS * QS1
	RH0 = A * SQR (C - NS * QS0) / NS
	GOTO INITIALIZE
IS03:
	IFLG = 0
	A = DARRAY(1)
	B = DARRAY(2)
	IF A = B THEN
		E = ZERO
		ES = ZERO
	ELSE
		ES = ONE - (B / A) ^ 2
		E = SQR (ES)
	END IF
	LAT1=DGR*DARRAY(3)
	LAT2=DGR*DARRAY(4)
	IF (ABS(LAT1+LAT2) < EPSLN) THEN
		PRINT " EQUAL LATITUDES FOR ST. PARALLELS ON OPPOSITE "
		PRINT " SIDES OF EQUATOR"
		IFLG = 401
		GOTO RETSUB
	END IF
	LON0=DGR*DARRAY(5)
	LAT0=ZERO
	SINPHI = SIN (LAT1)
	CON = SINPHI
	COSPHI = COS (LAT1)
	MS1 = FNMS (E,SINPHI,COSPHI)
	TS1 = FNTS (E,LAT1,SINPHI)
	SINPHI = SIN (LAT2)
	COSPHI = COS (LAT2)
	MS2 = FNMS (E,SINPHI,COSPHI)
	TS2 = FNTS (E,LAT2,SINPHI)
	SINPHI = SIN (LAT0)
	TS0 = FNTS (E,LAT0,SINPHI)
	IF (ABS(LAT1-LAT2) < EPSLN)THEN
		NS = CON
	ELSE
		NS = LOG (MS1 / MS2) / LOG (TS1 / TS2)
	END IF
	F = MS1 / (NS * TS1 ^ NS)
	RH0 = A * F * TS0 ^ NS
	GOTO INITIALIZE
IS04:
	IFLG = 0
	A = DARRAY(1)
	B = DARRAY(2)
	IF A = B THEN
		E = ZERO
		ES = ZERO
	ELSE
		ES = ONE - (B / A) ^ 2
		E = SQR (ES)
	END IF
	LON0=DGR*DARRAY(3)
	LAT1=DGR*DARRAY(4)
	M1 = COS(LAT1) / (SQR( ONE - ES * SIN(LAT1) ^2))
	GOTO INITIALIZE
IS05:
	IFLG = 0
	A = DARRAY(1)
	B = DARRAY(2)
	IF A = B THEN
		E = ZERO
		ES = ZERO
		E0 = ONE
		E1 = ZERO
		E2 = ZERO
	ELSE
		ES = ONE - (B / A) ^ 2
		E = SQR (ES)
		E0 = FNE0 (ES)
		E1 = FNE1 (ES)
		E2 = FNE2 (ES)
	END IF
	LON0=DGR*DARRAY(3)
	LAT0=ZERO
	ML0 = FNML (E0,E1,E2,LAT0)
	GOTO INITIALIZE
IS06:
	IFLG = 0
	A = DARRAY(1)
	B = DARRAY(2)
	IF A = B THEN
		E = ZERO
		ES = ZERO
		E0 = ONE
		E1 = ZERO
		E2 = ZERO
	ELSE
		ES = ONE - (B / A) ^ 2
		E = SQR (ES)
		E0 = FNE0 (ES)
		E1 = FNE1 (ES)
		E2 = FNE2 (ES)
	END IF
	LON0=DGR*DARRAY(3)
	KS0 = DARRAY(4)
	LAT0=ZERO
	ML0 = A * FNML (E0,E1,E2,LAT0)
	IND = 1
	IF E >= TOL THEN
		IND = 0
		ESP = ES / (ONE - ES)
	END IF
	GOTO INITIALIZE
IS07:
	IFLG = 0
	MODE = 0
	A = DARRAY(1)
	B = DARRAY(2)
	IF A = B THEN
		E = ZERO
		ES = ZERO
	ELSE
		ES = ONE - (B / A) ^ 2
		E = SQR (ES)
	END IF
	KS0 = DARRAY(3)
	LAT0=DGR*DARRAY(4)
	SINPH0 = SIN (LAT0)
	COSPH0 = COS (LAT0)
	CON = ONE - ES * SINPH0 * SINPH0
	DCOM = SQR (ONE - ES)
	BL = SQR (ONE + ES * COSPH0 ^ 4 / (ONE - ES))
	AL = A * BL * KS0 * DCOM / CON
	TS0 = FNTS (E,LAT0,SINPH0)
	CON = SQR (CON)
	D = BL * DCOM / (COSPH0 * CON)
	F = D + SGN(LAT0)*ABS(SQR(DBLMAX((D*D - ONE),0.0D0)))
	EL = F * TS0 ^ BL
	LAT1=DGR*DARRAY(6)
	LON1=DGR*DARRAY(7)
	LAT2=DGR*DARRAY(8)
	LON2=DGR*DARRAY(9)
	SINPHI = SIN (LAT1)
	TS1 = FNTS (E,LAT1,SINPHI)
	SINPHI = SIN (LAT2)
	TS2 = FNTS (E,LAT2,SINPHI)
	H = TS1 ^ BL
	L = TS2 ^ BL
	F = EL / H
	G = HALF * (F - ONE / F)
	J = (EL * EL - L * H) / (EL * EL + L * H)
	P = (L - H) / (L + H)
	DLON = LON1 - LON2
	IF (DLON < -PI) THEN LON2 = LON2 - 2.D0 * PI
	IF (DLON >  PI) THEN LON2 = LON2 + 2.D0 * PI
	DLON = LON1 - LON2
	LON0 = HALF * (LON1 + LON2) - ATN (J * TAN (HALF * BL * _
		DLON) / P) / BL
	DLON = FNADJL (LON1 - LON0)
	GAMMA = ATN (SIN (BL * DLON) / G)
	ALPHA = FNASIN (D * SIN (GAMMA))
	IF ABS(LAT1-LAT2)<=EPSLN THEN
		PRINT " IMPROPER PARAMETER"
		IFLG = 2002
		GOTO RETSUB
	END IF
	CON = ABS(LAT1)
	IF (CON.LE.EPSLN) OR (ABS(CON - HALFPI) <= EPSLN) THEN
		PRINT " IMPROPER PARAMETER"
		IFLG = 2002
		GOTO RETSUB
	END IF
	IF (ABS(ABS(LAT0) - HALFPI) <= EPSLN) THEN
		PRINT " IMPROPER PARAMETER"
		IFLG = 2002
		GOTO RETSUB
	END IF
	SINGAM = SIN (GAMMA)
	COSGAM = COS (GAMMA)
	SINALF = SIN (ALPHA)
	COSALF = COS (ALPHA)
	GOTO INITIALIZE
IS08:
	IFLG = 0
	A = DARRAY(1)
	B = DARRAY(2)
	IF A = B THEN
		E = ZERO
		ES = ZERO
		E0 = ONE
		E1 = ZERO
		E2 = ZERO
		E3 = ZERO
	ELSE
		ES = ONE - (B / A) ^ 2
		E = SQR (ES)
		E0 = FNE0(ES)
		E1 = FNE1(ES)
		E2 = FNE2(ES)
		E3 = FNE3(ES)
	END IF
	LAT1=DGR*DARRAY(3)
	LAT2=DGR*DARRAY(4)
	IF (ABS(LAT1+LAT2) < EPSLN) THEN
		PRINT " EQUAL LATITUDES FOR ST. PARALLELS ON OPPOSITE "
		PRINT " SIDES OF EQUATOR"
		IFLG = 401
		GOTO RETSUB
	END IF
	LON0=DGR*DARRAY(5)
	LAT0=ZERO
	SINPHI = SIN (LAT1)
	CON = SINPHI
	COSPHI = COS (LAT1)
	MS1 = FNMS (E,SINPHI,COSPHI)
	ML1 = FNML (E0,E1,E2,LAT1)
	SINPHI = SIN (LAT2)
	COSPHI = COS (LAT2)
	MS2 = FNMS (E,SINPHI,COSPHI)
	ML2 = FNML (E0,E1,E2,LAT2)
	IF (ABS(LAT1-LAT2) < EPSLN) THEN
		NS = SINPHI
	ELSE
		NS = (MS1 - MS2) / (ML2 - ML1)
	END IF
	GL = ML1 + MS1 / NS
	ML0 = FNML (E0,E1,E2,LAT0)
	RH0= A * (GL - ML0)
INITIALIZE:
	ON JOB% GOTO FORWARD,INVERSE
FORWARD:
	ON PTYP% GOTO PF06,PF02,PF03,PF04,PF05,PF06,PF07,PF08
	PRINT "ILLEGAL PROJECTION"
	GOTO RETSUB
PF02:
	SINPHI = SIN (DGR*GEOG(2))
	COSPHI = COS (DGR*GEOG(2))
	QS = FNQS (E,SINPHI,COSPHI)
	RH = A * SQR (C - NS * QS) / NS
	THETA = NS * FNADJL (DGR*GEOG(1) - LON0)
	PROJ(1) = RH * SIN (THETA)
	PROJ(2) = RH0 - RH * COS (THETA)
GOTO RETSUB
PF03:
	CON = ABS (ABS (DGR*GEOG(2)) - HALFPI)
	IF (CON > EPSLN) THEN
		SINPHI = SIN (DGR*GEOG(2))
		TS = FNTS (E,DGR*GEOG(2),SINPHI)
		RH = A * F * TS ^ NS
	ELSE
		CON = DGR*GEOG(2) * NS
		IF (CON > ZERO) THEN
			RH = ZERO
		ELSE
			PRINT "POINT CANNOT BE PROJECTED"
			IFLG=402
			GOTO RETSUB
		END IF
	END IF
	THETA = NS * FNADJL (DGR*GEOG(1) - LON0)
	PROJ(1) = RH * SIN (THETA)
	PROJ(2) = RH0 - RH * COS (THETA)
GOTO RETSUB
PF04:
	IF (ABS(ABS(DGR*GEOG(2)) - HALFPI) <= EPSLN) THEN
		PRINT "TRANSFORMATION CANNOT BE COMPUTED AT THE POLES"
		IFLG = 501
		GOTO RETSUB
	END IF
	SINPHI = SIN (DGR*GEOG(2))
	TS = FNTS (E,DGR*GEOG(2),SINPHI)
	PROJ(1) = A * M1 * FNADJL (DGR*GEOG(1) - LON0)
	PROJ(2) = -A * M1 * LOG (TS)
GOTO RETSUB
PF05:
	CON = FNADJL (DGR*GEOG(1) - LON0)
	IF (ABS(DGR*GEOG(2)) <= TOL) THEN
		PROJ(1) = A * CON
		PROJ(2) = A * ML0
	ELSE
		SINPHI = SIN (DGR*GEOG(2))
		COSPHI = COS (DGR*GEOG(2))
		ML = FNML (E0,E1,E2,DGR*GEOG(2))
		MS = FNMS (E,SINPHI,COSPHI)
		CON = CON * SINPHI
		PROJ(1) = A * MS * SIN (CON) / SINPHI
		PROJ(2) = A * (ML - ML0 + MS * (ONE - COS (CON)) / SINPHI)
	END IF
GOTO RETSUB
PF06:
	DLON = FNADJL (DGR*GEOG(1)-LON0)
	LAT = DGR*GEOG(2)
	IF (IND <> 0) THEN
		COSPHI = COS (LAT)
		B = COSPHI * SIN (DLON)
		IF (ABS(ABS(B) - ONE) <= EPSLN) THEN
			PRINT "POINT PROJECTS INTO INFINITY"
			IFLG = 901
		ELSE
			PROJ(1) = HALF * A * KS0 * LOG ((ONE + B) / (ONE - B))
			CON = FNACOS (COSPHI * COS (DLON) / SQR (ONE - B * B))
			IF (LAT < ZERO) THEN CON =-CON
			PROJ(2) = A * KS0 * (CON - LAT0)
		END IF
	ELSE
		SINPHI = SIN (LAT)
		COSPHI = COS (LAT)
		AL = COSPHI * DLON
		ALS = AL * AL
		C = ESP * COSPHI * COSPHI
		TQ = TAN (LAT)
		T = TQ * TQ
		N = A / SQR (ONE - ES * SINPHI * SINPHI)
		ML = A * FNML (E0,E1,E2,LAT)
		TEMPCON=FIVE - 18.0D0 * T + T * T + 72.0D0 * _
			C - 58.0D0 * ESP
		TEMPCON=ONE + ALS / SIX * (ONE - T + C + _
			ALS / 20.0D0 * TEMPCON)
		PROJ(1) = KS0 * N * AL * TEMPCON
		TEMPCON=(FIVE - T + NINE * C + FOUR * C * C + ALS / 30.0D0 * _
			(61.0D0 - 58.0D0 * T + T * T + 600.0D0 * C - _
			330.0D0 * ESP))
		PROJ(2) = KS0 * (ML - ML0 + N * TQ * (ALS * (HALF + ALS / 24.0D0 * _
			TEMPCON)))
	END IF
GOTO RETSUB
PF07:
	SINPHI = SIN (DGR*GEOG(2))
	DLON = FNADJL (DGR*GEOG(1) - LON0)
	VL = SIN (BL * DLON)
	IF (ABS(ABS(DGR*GEOG(2)) - HALFPI) <= EPSLN) THEN
		UL = SINGAM * (SGN(DGR*GEOG(2))*ABS(ONE))
		US = AL * DGR*GEOG(2) / BL
	ELSE
		TS = FNTS (E,DGR*GEOG(2),SINPHI)
		Q = EL / TS ^ BL
		S = HALF * (Q - ONE / Q)
		T = HALF * (Q + ONE / Q)
		UL = (S * SINGAM - VL * COSGAM) / T
		CON = COS (BL * DLON)
		IF (ABS(CON) >= TOL) THEN
			US = AL * ATN ((S * COSGAM + VL * SINGAM) / CON) / BL
			IF (CON < ZERO) THEN US = US + PI * AL / BL
		ELSE
			US = AL * BL * DLON
		END IF
	END IF
	IF (ABS(ABS(UL) - ONE) <= EPSLN) THEN
		PRINT "POINT PROJECTS INTO INFINITY"
		IFLG = 2001
		GOTO RETSUB
	ELSE
		VS = HALF * AL * LOG ((ONE - UL) / (ONE + UL)) / BL
		PROJ(1) = VS * COSALF + US * SINALF
		PROJ(2) = US * COSALF - VS * SINALF
	END IF
GOTO RETSUB
PF08:
	ML = FNML(E0,E1,E2,DGR*GEOG(2))
	RH = A * (GL - ML)
	THETA = NS * FNADJL(DGR*GEOG(1) - LON0)
	PROJ(1) = RH * SIN(THETA)
	PROJ(2)= RH0 - RH * COS(THETA)
GOTO RETSUB
INVERSE:
	IFLG = 0
	ON PTYP% GOTO PI06,PI02,PI03,PI04,PI05,PI06,PI07,PI08
	PRINT "ILLEGAL PROJECTION"
	GOTO RETSUB
PI02:
	X = PROJ(1)
	Y = RH0 - PROJ(2)
	RH = SGN(NS)*ABS(SQR(X*X + Y*Y))
	THETA = ZERO
	CON = SGN(NS)*ABS(ONE)
	IF (RH <> ZERO) THEN THETA = ATN ((CON * X) / (CON * Y))
	CON = RH * NS / A
	QS = (C - CON * CON) / NS
	IF (E >= TOL) THEN
		CON = ONE - HALF * (ONE - ES) * LOG ((ONE - E) / _
			(ONE + E)) / E
		IF ((ABS(CON) - ABS(QS)) <= TOL) THEN
			GEOG(2) = SGN(QS)*ABS(HALFPI)
		ELSE
			GEOG(2) = FNPHI1 (E,QS,IFLG)
		END IF
	ELSE
		GEOG(2) = FNPHI1 (E,QS,IFLG)
	END IF
	GEOG(1) = FNADJL (THETA / NS + LON0)
	GEOG(1)=GEOG(1)/DGR
	GEOG(2)=GEOG(2)/DGR
GOTO RETSUB
PI03:
	X = PROJ(1)
	Y = RH0 - PROJ(2)
	RH = SGN(NS)*ABS(SQR(X*X + Y*Y))
	THETA = ZERO
	CON = SGN(NS)*ABS(ONE)
	IF (RH <> ZERO) THEN
		THETA = ATN ((CON * X) / (CON * Y))
	END IF
	IF (RH<>ZERO) OR (NS>ZERO) THEN
		CON = ONE / NS
		TS = (RH / (A * F)) ^ CON
		GEOG(2) = FNPHI2 (E,TS,IFLG)
		IF (IFLG <> 0) GOTO RETSUB
	ELSE
		GEOG(2) = - HALFPI
	END IF
	GEOG(1) = FNADJL (THETA / NS + LON0)
	GEOG(1)=GEOG(1)/DGR
	GEOG(2)=GEOG(2)/DGR
GOTO RETSUB
PI04:
	X = PROJ(1)
	Y = PROJ(2)
	TS = EXP (- Y / (A * M1))
	GEOG(2) = FNPHI2 (E,TS,IFLG)
	IF (IFLG <> 0) GOTO RETSUB
	GEOG(1) = FNADJL (LON0 + X / (A * M1))
	GEOG(1)=GEOG(1)/DGR
	GEOG(2)=GEOG(2)/DGR
GOTO RETSUB
PI05:
	X = PROJ(1)
	Y = PROJ(2)
	AL = ML0 + Y / A
	IF (ABS (AL) <= TOL) THEN
		GEOG(1) = X / A + LON0
		GEOG(2) = ZERO
	ELSE
		B = AL * AL + (X / A) ^ 2
		CALL PHI4(ES,E0,E1,E2,E3,AL,B,C,IFLG,RESULT)
		IF (IFLG <> 0) GOTO RETSUB
		GEOG(2)=RESULT
		GEOG(1) = FNADJL (FNASIN (X * C / A) / SIN (GEOG(2)) + LON0)
	END IF
	GEOG(1)=GEOG(1)/DGR
	GEOG(2)=GEOG(2)/DGR
GOTO RETSUB
PI06:
	X = PROJ(1)
	Y = PROJ(2)
	IF (IND <> 0) THEN
		F = EXP (X / (A * KS0))
		G = HALF * (F - ONE / F)
		C = LAT0 + Y / (A * KS0)
		H = COS (C)
		CON = SQR ((ONE - H * H) / (ONE + G * G))
		GEOG(2) = FNASIN (CON)
		IF (C < ZERO) THEN
			GEOG(2) =-GEOG(2)
		END IF
		IF (G<>ZERO OR H<>ZERO) THEN
			GEOG(1) = FNADJL (ATN (G/H) + LON0)
		ELSE
			GEOG(1) = LON0
		END IF
	ELSE
		CON = (ML0 + Y / KS0) / A
		PHI = FNPHI3 (CON,E0,E1,E2,E3,IFLG)
		IF (IFLG <> 0) GOTO RETSUB
		IF (ABS(PHI) >= HALFPI) THEN
			GEOG(2) = SGN(NS)*ABS(HALFPI)
			GEOG(1) = LON0
		ELSE
			SINPHI = SIN (PHI)
			COSPHI = COS (PHI)
			TANPHI = TAN (PHI)
			C = ESP * COSPHI * COSPHI
			CS = C * C
			T = TANPHI * TANPHI
			TS = T * T
			CON = ONE - ES * SINPHI * SINPHI
			N = A / SQR (CON)
			R = N * (ONE - ES) / CON
			D = X / (N * KS0)
			DS = D * D
			TEMPCON=61.0D0 + 90.0D0 * T + 298.0D0 * C + _
				45.0D0 * TS - 252.0D0 * ESP - THREE * CS
			TEMPCON=FIVE + THREE * T + TEN * C - FOUR * CS - NINE * ESP - _
				DS / 30.0D0 * TEMPCON 
			GEOG(2) = PHI - (N * TANPHI * DS / R) * (HALF - DS / 24.0D0 * _
				TEMPCON)
			TEMPCON=FIVE - TWO * C + 28.0D0 * T - _
				THREE * CS + EIGHT * ESP + 24.0D0 * TS
			TEMPCON=D * (ONE - DS / SIX * (ONE + TWO * _
				T + C - DS / 20.0D0 * TEMPCON)) / COSPHI
			GEOG(1) = FNADJL (LON0 + TEMPCON)
		END IF
	END IF
	GEOG(1)=GEOG(1)/DGR
	GEOG(2)=GEOG(2)/DGR
GOTO RETSUB
PI07:
	X = PROJ(1)
	Y = PROJ(2)
	VS = X * COSALF - Y * SINALF
	US = Y * COSALF + X * SINALF
	Q = EXP (- BL * VS / AL)
	S = HALF * (Q - ONE / Q)
	T = HALF * (Q + ONE / Q)
	VL = SIN (BL * US / AL)
	UL = (VL * COSGAM + S * SINGAM) / T
	IF (ABS (ABS (UL) - ONE) < EPSLN) THEN
		GEOG(1) = LON0
		GEOG(2) = SGN(UL)*ABS(HALFPI)
	ELSE
		CON = ONE / BL
		TS = (EL / SQR ((ONE + UL) / (ONE - UL))) ^ CON
		GEOG(2) = FNPHI2 (E,TS,IFLG)
		IF (IFLG <> 0) THEN GOTO RETSUB
		CON = COS (BL * US / AL)
		LON = LON0 - ATN ((S * COSGAM - VL * SINGAM) / CON) / BL
		GEOG(1) = FNADJL (LON)
	END IF
	GEOG(1)=GEOG(1)/DGR
	GEOG(2)=GEOG(2)/DGR
GOTO RETSUB
PI08:
	X = PROJ(1)
	Y = RH0 - PROJ(2)
	RH = SGN(NS)*ABS(SQR(X * X + Y * Y))
	THETA = ZERO
	CON = SGN(NS) * ABS(ONE)
	IF RH <> ZERO THEN
		THETA = ATN( (CON * X) / (CON * Y))
	END IF
	ML = GL - RH / A
	GEOG(2) = FNPHI3(ML,E0,E1,E2,E3,IFLG)
	GEOG(1) = FNADJL ( THETA / NS + LON0)
	GEOG(1)=GEOG(1)/DGR
	GEOG(2)=GEOG(2)/DGR
RETSUB:
	END SUB
SUB PHI4 (ECCNTS,E0,E1,E2,E3,A,B,C,IFLG,RESULT) STATIC
' SUBROUTINE TO COMPUTE LATITUDE ANGLE (PHI-4).
	ONE=1.0D0
	TWO=2.0D0
	FOUR=4.0D0
	SIX=6.0D0
	TOL=1.0D-11
	NIT%=15
	PHI = A
	FOR II% = 1 TO NIT%
		SINPHI = SIN (PHI)
		TANPHI = TAN (PHI)
		C=TANPHI * SQR(ONE - ECCNTS * SINPHI * SINPHI)
		SIN2PH = SIN (TWO * PHI)
		ML = E0 * PHI - E1 * SIN2PH + E2 * SIN (FOUR * PHI) - _
			E3 * SIN (SIX * PHI)
		MLP = E0 - TWO * E1 * COS (TWO * PHI) + FOUR * E2 * _
			COS (FOUR * PHI) - SIX * E3 * COS (SIX * PHI)
		CON1 = TWO * ML + C * (ML * ML + B) - TWO * A * _
			(C * ML + ONE)
		CON2 = ECCNTS * SIN2PH * (ML * ML + B - TWO * A * ML) / (TWO * C)
		CON3 = TWO * (A - ML) * (C * MLP - TWO / SIN2PH) - TWO * MLP
		DPHI = CON1 / (CON2 + CON3)
		PHI = PHI + DPHI
		IF (ABS(DPHI) <= TOL) GO TO PHI420
		RESULT = PHI
	NEXT II%
	PRINT "LATITUDE FAILED TO CONVERGE"
	IFLG = 24
PHI420:
      END SUB
